/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

public class Utils {
    public static final int getSubversion(String version, int portion) {
        if (portion < 0) {
            throw new IllegalArgumentException("Negative not allowed: " + portion);
        }
        int len = version.length();
        int j = 0;
        while (--portion >= 0) {
            if ((j = Utils.nextVerSeparator(version, j) + 1) < len) continue;
            return 0;
        }
        String s = version.substring(j, Utils.nextVerSeparator(version, j));
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable ex) {
            int base;
            s = s.toLowerCase();
            if (s.startsWith("rc")) {
                base = -100;
                j = 2;
            } else if (s.startsWith("beta")) {
                base = -300;
                j = 4;
            } else if (s.startsWith("alpha")) {
                base = -500;
                j = 5;
            } else {
                return 0;
            }
            if (j < s.length()) {
                try {
                    return base + Integer.parseInt(s.substring(j));
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
            return base;
        }
    }

    private static final int nextVerSeparator(String version, int from) {
        char cc;
        int len = version.length();
        while (from < len && ((cc = version.charAt(from)) >= '0' && cc <= '9' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z')) {
            ++from;
        }
        return from;
    }
}

