/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.media;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.zkoss.io.NullInputStream;
import org.zkoss.io.NullReader;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.media.Media;

public class AMedia
implements Media {
    protected static final InputStream DYNAMIC_STREAM = new NullInputStream();
    protected static final Reader DYNAMIC_READER = new NullReader();
    private byte[] _bindata;
    private String _strdata;
    private InputStream _isdata;
    private Reader _rddata;
    private String _ctype;
    private String _format;
    private String _name;

    public AMedia(String name, String format, String ctype, byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this._bindata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, String data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this._strdata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, InputStream data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this._isdata = data;
        this.setup(name, format, ctype);
    }

    public AMedia(String name, String format, String ctype, Reader data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this._rddata = data;
        this.setup(name, format, ctype);
    }

    private void setup(String name, String format, String ctype) {
        int j;
        if (ctype != null && (j = ctype.indexOf(59)) >= 0) {
            ctype = ctype.substring(0, j);
        }
        if (ctype != null && format == null) {
            format = ContentTypes.getFormat(ctype);
        } else if (ctype == null && format != null) {
            ctype = ContentTypes.getContentType(format);
        }
        if (name != null && format == null && (j = name.lastIndexOf(46)) >= 0) {
            format = name.substring(j + 1);
            if (ctype == null) {
                ctype = ContentTypes.getContentType(format);
            }
        }
        this._name = name;
        this._format = format;
        this._ctype = ctype;
    }

    public boolean isBinary() {
        return this._bindata != null || this._isdata != null;
    }

    public boolean inMemory() {
        return this._bindata != null || this._strdata != null;
    }

    public byte[] getByteData() {
        if (this._bindata == null) {
            throw this.newIllegalStateException();
        }
        return this._bindata;
    }

    public String getStringData() {
        if (this._strdata == null) {
            throw this.newIllegalStateException();
        }
        return this._strdata;
    }

    public InputStream getStreamData() {
        if (this._isdata != null) {
            return this._isdata;
        }
        if (this._bindata != null) {
            return new ByteArrayInputStream(this._bindata);
        }
        throw this.newIllegalStateException();
    }

    public Reader getReaderData() {
        if (this._rddata != null) {
            return this._rddata;
        }
        if (this._strdata != null) {
            return new StringReader(this._strdata);
        }
        throw this.newIllegalStateException();
    }

    private IllegalStateException newIllegalStateException() {
        return new IllegalStateException("Use get" + (this._bindata != null ? "Byte" : (this._strdata != null ? "String" : (this._isdata != null ? "Stream" : "Reader"))) + "Data() instead");
    }

    public String getName() {
        return this._name;
    }

    public String getFormat() {
        return this._format;
    }

    public String getContentType() {
        return this._ctype;
    }

    public String toString() {
        return this._name != null ? this._name : "Media " + this._format;
    }
}

