/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.el;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.el.FunctionMappers;
import org.zkoss.el.impl.MethodFunction;
import org.zkoss.idom.Element;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelException;

public class SimpleMapper
implements FunctionMapper {
    private final FunctionMapper _parent;
    private final Map _maps = new HashMap();

    public SimpleMapper() {
        this(null);
    }

    public SimpleMapper(FunctionMapper parent) {
        if (parent == this) {
            throw new IllegalArgumentException("parent cannot be itself");
        }
        this._parent = parent;
    }

    public void load(String prefix, String uri, Locator locator) throws XelException, IOException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._maps.containsKey(prefix)) {
            throw new XelException("The prefix, " + prefix + ", is already used");
        }
        URL url = locator.getResource(uri);
        if (url == null) {
            throw new FileNotFoundException(uri);
        }
        try {
            this._maps.put(prefix, SimpleMapper.toMethodFunction(FunctionMappers.loadMethods(url)));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XelException(ex);
        }
    }

    private static Map toMethodFunction(Map mtds) {
        Iterator it = mtds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Method mtd = (Method)me.getValue();
            if (mtd == null) continue;
            me.setValue(new MethodFunction(mtd));
        }
        return mtds;
    }

    public void load(String prefix, Element root) throws XelException, IOException {
        if (prefix == null || root == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._maps.containsKey(prefix)) {
            throw new XelException("The prefix, " + prefix + ", is already used");
        }
        try {
            this._maps.put(prefix, SimpleMapper.toMethodFunction(FunctionMappers.loadMethods(root)));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XelException(ex);
        }
    }

    public Function resolveFunction(String prefix, String name) {
        Map mtds = (Map)this._maps.get(prefix);
        return mtds != null ? (Function)mtds.get(name) : (this._parent != null ? this._parent.resolveFunction(prefix, name) : null);
    }

    public Collection getClassNames() {
        return Collections.EMPTY_LIST;
    }

    public Class resolveClass(String name) throws XelException {
        return null;
    }
}

