/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class Files {
    public static final char DRIVE_SEPARATOR_CHAR;
    public static int CP_PRESERVE;
    public static int CP_UPDATE;
    public static int CP_OVERWRITE;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Files() {
    }

    public static final String correctSeparator(String flnm) {
        return File.separatorChar != '/' ? flnm.replace('/', File.separatorChar) : flnm;
    }

    public static final File getConfigDirectory() {
        String confdir = System.getProperty("org.zkoss.io.conf.dir", null);
        if (confdir != null) {
            return new File(confdir);
        }
        String userdir = System.getProperty("user.dir", ".");
        File fl0 = new File(userdir, "conf");
        if (Files.exists(fl0) == null) {
            File fl = Files.exists(new File(userdir, "config"));
            if (fl != null) {
                return fl;
            }
            if (!".".equals(userdir)) {
                fl = Files.exists(new File(userdir, "../conf"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File(userdir, "../config"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File("./conf"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File("./config"));
                if (fl != null) {
                    return fl;
                }
            }
            if ((fl = Files.exists(new File("../conf"))) != null) {
                return fl;
            }
            fl = Files.exists(new File("../config"));
            if (fl != null) {
                return fl;
            }
        }
        return fl0;
    }

    private static final File exists(File fl) {
        return fl.exists() ? fl : null;
    }

    public static final byte[] readAll(InputStream in) throws IOException {
        int v;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[16384];
        while ((v = in.read(buf)) >= 0) {
            out.write(buf, 0, v);
        }
        return out.toByteArray();
    }

    public static final StringBuffer readAll(Reader reader) throws IOException {
        StringWriter writer = new StringWriter(16384);
        Files.copy(writer, reader);
        return writer.getBuffer();
    }

    public static final void copy(Writer writer, Reader reader) throws IOException {
        int v;
        char[] buf = new char[4096];
        while ((v = reader.read(buf)) >= 0) {
            if (v <= 0) continue;
            writer.write(buf, 0, v);
        }
    }

    public static final void copy(OutputStream out, InputStream in) throws IOException {
        int v;
        byte[] buf = new byte[8192];
        while ((v = in.read(buf)) >= 0) {
            if (v <= 0) continue;
            out.write(buf, 0, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File dst, Reader reader, String charset) throws IOException {
        File parent = dst.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        OutputStreamWriter writer = charset != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(dst), charset) : new FileWriter(dst);
        try {
            Files.copy(writer, reader);
        }
        finally {
            Files.close(reader);
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File dst, InputStream in) throws IOException {
        File parent = dst.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        try {
            Files.copy(out, in);
        }
        finally {
            Files.close(in);
            ((OutputStream)out).close();
        }
    }

    public static final void copy(File dst, File src, int flags) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.toString());
        }
        if (dst.isDirectory()) {
            if (src.isDirectory()) {
                Files.copyDir(dst, src, flags);
            } else {
                Files.copyFile(new File(dst, src.getName()), src, flags);
            }
        } else if (dst.isFile()) {
            if (src.isDirectory()) {
                throw new IOException("Unable to copy a directory, " + src + ", to a file, " + dst);
            }
            Files.copyFile(dst, src, flags);
        } else if (src.isDirectory()) {
            Files.copyDir(dst, src, flags);
        } else {
            Files.copyFile(dst, src, flags);
        }
    }

    private static final void copyFile(File dst, File src, int flags) throws IOException {
        if (!$assertionsDisabled && !src.isFile()) {
            throw new AssertionError();
        }
        if (dst.equals(src)) {
            throw new IOException("Copy to the same file, " + src);
        }
        if ((flags & CP_OVERWRITE) == 0) {
            if ((flags & CP_UPDATE) != 0) {
                if (dst.lastModified() >= src.lastModified()) {
                    return;
                }
            } else if (dst.exists()) {
                throw new IOException("The destination already exists, " + dst);
            }
        }
        Files.copy(dst, (InputStream)new FileInputStream(src));
        if ((flags & CP_PRESERVE) != 0) {
            dst.setLastModified(src.lastModified());
        }
    }

    private static final void copyDir(File dst, File src, int flags) throws IOException {
        if (!$assertionsDisabled && !src.isDirectory()) {
            throw new AssertionError();
        }
        File[] srcs = src.listFiles();
        for (int j = 0; j < srcs.length; ++j) {
            Files.copy(new File(dst, srcs[j].getName()), srcs[j], flags);
        }
    }

    public static final boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] fls = file.listFiles();
            for (int j = 0; j < fls.length; ++j) {
                if (Files.deleteAll(fls[j])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static final void close(InputStream strm) {
        if (strm != null) {
            try {
                strm.close();
            }
            catch (IOException ex) {
                System.out.println("Unable to close an input stream");
            }
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException ex) {
                System.out.println("Unable to close a reader");
            }
        }
    }

    static {
        $assertionsDisabled = !Files.class.desiredAssertionStatus();
        DRIVE_SEPARATOR_CHAR = (char)(System.getProperty("os.name").indexOf("Windows") < 0 ? 0 : 58);
        CP_PRESERVE = 1;
        CP_UPDATE = 2;
        CP_OVERWRITE = 4;
    }
}

