/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.el;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.servlet.jsp.el.FunctionMapper;
import org.zkoss.el.Taglib;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.lang.reflect.SerializableMethod;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.AbstractLoader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;

public class FunctionMappers {
    private static final Log log = Log.lookup(FunctionMappers.class);
    private static final ResourceCache _reces;
    public static final FunctionMapper EMPTY_MAPPER;

    private FunctionMappers() {
    }

    public static final FunctionMapper getFunctionMapper(List taglibs, Locator loc) {
        if (taglibs == null || taglibs.isEmpty()) {
            return null;
        }
        HashMap<String, Map> mappers = new HashMap<String, Map>();
        Iterator it = taglibs.iterator();
        while (it.hasNext()) {
            Taglib taglib = (Taglib)it.next();
            URL url = loc.getResource(taglib.getURI());
            if (url == null) {
                throw new MissingResourceException("Taglib not found: " + taglib.getURI(), loc.getClass().getName(), taglib.getURI());
            }
            Map mtds = (Map)_reces.get(url);
            if (mtds.isEmpty()) continue;
            mappers.put(taglib.getPrefix(), mtds);
        }
        return new MyMapper(mappers);
    }

    public static final Map loadMethods(URL xmlUrl) throws Exception {
        Element root = new SAXBuilder(true, false, true).build(xmlUrl).getRootElement();
        return FunctionMappers.loadMethods(root);
    }

    public static final Map loadMethods(Element root) throws Exception {
        HashMap<String, Method> mtds = new HashMap<String, Method>();
        Exception excp = null;
        Iterator it = root.getElements("function").iterator();
        while (it.hasNext()) {
            Class cls;
            Element e = (Element)it.next();
            String name = IDOMs.getRequiredElementValue(e, "name");
            String clsName = IDOMs.getRequiredElementValue(e, "function-class");
            String sig = IDOMs.getRequiredElementValue(e, "function-signature");
            try {
                cls = Classes.forNameByThread(clsName);
            }
            catch (ClassNotFoundException ex) {
                log.error("Class not found: " + clsName + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
                continue;
            }
            try {
                Method mtd = Classes.getMethodBySignature(cls, sig, null);
                if ((mtd.getModifiers() & 8) != 0) {
                    mtds.put(name, mtd);
                    continue;
                }
                log.error("Not a static method: " + mtd);
            }
            catch (ClassNotFoundException ex) {
                log.error("Relavant class not found when loading " + clsName + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (NoSuchMethodException ex) {
                log.error("Method not found in " + clsName + ": " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (IllegalSyntaxException ex) {
                log.error("Illegal Signature: " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
        }
        if (excp != null) {
            throw excp;
        }
        return mtds;
    }

    static {
        EMPTY_MAPPER = new EmptyMapper();
        try {
            _reces = new ResourceCache(new TaglibLoader());
            _reces.setCheckPeriod(1800000);
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }

    private static class TaglibLoader
    extends AbstractLoader {
        private TaglibLoader() {
        }

        public Object load(Object src) throws Exception {
            return FunctionMappers.loadMethods((URL)src);
        }
    }

    private static class EmptyMapper
    implements FunctionMapper,
    Serializable {
        private static final long serialVersionUID = 20060622L;

        private EmptyMapper() {
        }

        public Method resolveFunction(String prefix, String name) {
            return null;
        }
    }

    private static class MyMapper
    implements FunctionMapper,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = 20060622L;
        private Map _mappers;

        private MyMapper(Map mappers) {
            this._mappers = mappers;
            Iterator it = mappers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                HashMap mtds = new HashMap((Map)me.getValue());
                MyMapper.toSerializableMethod(mtds);
                me.setValue(mtds);
            }
        }

        private static void toSerializableMethod(Map mtds) {
            Iterator it = mtds.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Method mtd = (Method)me.getValue();
                if (mtd == null) continue;
                me.setValue(new SerializableMethod(mtd));
            }
        }

        public Method resolveFunction(String prefix, String name) {
            SerializableMethod mtd;
            Map mtds = (Map)this._mappers.get(prefix);
            if (mtds != null && (mtd = (SerializableMethod)mtds.get(name)) != null) {
                return mtd.getMethod();
            }
            return null;
        }

        public Object clone() {
            MyMapper clone;
            try {
                clone = (MyMapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            clone._mappers = new HashMap(clone._mappers);
            Iterator it = clone._mappers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                me.setValue(new HashMap((Map)me.getValue()));
            }
            return clone;
        }

        public int hashCode() {
            return ((Object)this._mappers).hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MyMapper && ((Object)this._mappers).equals(((MyMapper)o)._mappers);
        }
    }
}

