/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;

public class Strings {
    public static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final StringBuffer encode(StringBuffer sb, int val) {
        if (val < 0) {
            sb.append('z');
            val = -val;
        }
        do {
            int v;
            if ((v = val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0);
        return sb;
    }

    public static final StringBuffer encode(StringBuffer sb, long val) {
        if (val < 0L) {
            sb.append('z');
            val = -val;
        }
        do {
            int v;
            if ((v = (int)val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0L);
        return sb;
    }

    public static final String encode(int val) {
        return Strings.encode(new StringBuffer(12), val).toString();
    }

    public static final String encode(long val) {
        return Strings.encode(new StringBuffer(20), val).toString();
    }

    public static final int anyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return src.length();
            }
            case 1: {
                int j = src.indexOf(delimiters.charAt(0), from);
                return j >= 0 ? j : src.length();
            }
        }
        int len = src.length();
        while (from < len && delimiters.indexOf(src.charAt(from)) < 0) {
            ++from;
        }
        return from;
    }

    public static final int lastAnyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return -1;
            }
            case 1: {
                return src.lastIndexOf(delimiters.charAt(0), from);
            }
        }
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && delimiters.indexOf(src.charAt(from)) < 0) {
            --from;
        }
        return from;
    }

    public static final int skipWhitespaces(CharSequence src, int from) {
        int len = src.length();
        while (from < len && Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final int skipWhitespacesBackward(CharSequence src, int from) {
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && Character.isWhitespace(src.charAt(from))) {
            --from;
        }
        return from;
    }

    public static final int nextWhitespace(CharSequence src, int from) {
        int len = src.length();
        while (from < len && !Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final String escape(String s, String specials) {
        int k;
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        int len = s.length();
        while ((k = Strings.anyOf(s, specials, j)) < len) {
            if (sb == null) {
                sb = new StringBuffer(len + 4);
            }
            char cc = s.charAt(k);
            switch (cc) {
                case '\n': {
                    cc = 'n';
                    break;
                }
                case '\t': {
                    cc = 't';
                    break;
                }
                case '\r': {
                    cc = 'r';
                    break;
                }
                case '\f': {
                    cc = 'f';
                }
            }
            sb.append(s.substring(j, k)).append('\\').append(cc);
            j = k + 1;
        }
        if (sb == null) {
            return s;
        }
        return sb.append(s.substring(j)).toString();
    }

    public static final StringBuffer appendEscape(StringBuffer sb, String s, String specials) {
        if (s == null) {
            return sb;
        }
        int j = 0;
        int len = s.length();
        int k;
        while ((k = Strings.anyOf(s, specials, j)) < len) {
            char cc = s.charAt(k);
            switch (cc) {
                case '\n': {
                    cc = 'n';
                    break;
                }
                case '\t': {
                    cc = 't';
                    break;
                }
                case '\r': {
                    cc = 'r';
                    break;
                }
                case '\f': {
                    cc = 'f';
                }
            }
            sb.append(s.substring(j, k)).append('\\').append(cc);
            j = k + 1;
        }
        return sb.append(s.substring(j));
    }

    public static final String unescape(String s) {
        int k;
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        while ((k = s.indexOf(92, j)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(s.length());
            }
            char cc = s.charAt(k + 1);
            switch (cc) {
                case 'n': {
                    cc = '\n';
                    break;
                }
                case 't': {
                    cc = '\t';
                    break;
                }
                case 'r': {
                    cc = '\r';
                    break;
                }
                case 'f': {
                    cc = '\f';
                }
            }
            sb.append(s.substring(j, k)).append(cc);
            j = k + 2;
        }
        if (sb == null) {
            return s;
        }
        return sb.append(s.substring(j)).toString();
    }

    public static final Result substring(String src, int from, char until) {
        return Strings.substring(src, from, until, true);
    }

    /*
     * Unable to fully structure code
     */
    public static final Result substring(String src, int from, char until, boolean handleBackslash) {
        len = src.length();
        sb = new StringBuffer(len);
        quoted = false;
        while (from < len) {
            block9: {
                cc = src.charAt(from);
                if (!quoted) break block9;
                quoted = false;
                switch (cc) {
                    case 'f': {
                        cc = '\f';
                        break;
                    }
                    case 'n': {
                        cc = '\n';
                        break;
                    }
                    case 'r': {
                        cc = '\r';
                        break;
                    }
                    case 't': {
                        cc = '\t';
                    }
                }
                ** GOTO lbl-1000
            }
            if (cc == until) break;
            if (handleBackslash && cc == '\\') {
                quoted = true;
            } else lbl-1000:
            // 2 sources

            {
                sb.append(cc);
            }
            ++from;
        }
        return new Result(from, sb.toString(), from < len ? until : '\u0000');
    }

    public static final Result nextToken(String src, int from, char[] separators) throws IllegalSyntaxException {
        return Strings.nextToken(src, from, separators, true, true);
    }

    public static final Result nextToken(String src, int from, char[] separators, boolean handleBackslash, boolean handleQuotation) throws IllegalSyntaxException {
        int j;
        int len = src.length();
        if ((from = Strings.skipWhitespaces(src, from)) >= len) {
            return null;
        }
        char cc = src.charAt(from);
        if (handleQuotation && (cc == '\'' || cc == '\"')) {
            Result res = Strings.substring(src, from + 1, cc, handleBackslash);
            if (res.separator != cc) {
                throw new IllegalSyntaxException(MCommon.QUOTE_UNMATCHED, src);
            }
            res.next = Strings.skipWhitespaces(src, res.next + 1);
            if (res.next < len && Strings.isSeparator(src.charAt(res.next), separators)) {
                ++res.next;
            }
            return res;
        }
        int next = j = Strings.nextSeparator(src, from, separators, handleBackslash, handleQuotation);
        if (j < len) {
            if (handleQuotation) {
                char c = src.charAt(j);
                if (c != '\'' && c != '\"') {
                    ++next;
                }
            } else {
                ++next;
            }
        }
        if (j == from) {
            return new Result(next, "", src.charAt(j));
        }
        int k = 1 + Strings.skipWhitespacesBackward(src, j - 1);
        return new Result(next, k > from ? (handleBackslash ? Strings.unescape(src.substring(from, k)) : src.substring(from, k)) : "", j < len ? src.charAt(j) : (char)'\u0000');
    }

    public static int nextSeparator(String src, int from, char[] separators, boolean handleBackslash, boolean handleQuotation) {
        boolean quoted = false;
        int len = src.length();
        while (from < len) {
            char cc = src.charAt(from);
            if (quoted) {
                quoted = false;
            } else if (handleBackslash && cc == '\\') {
                quoted = true;
            } else {
                if (handleQuotation && (cc == '\'' || cc == '\"')) {
                    return from;
                }
                if (Strings.isSeparator(cc, separators)) {
                    return from;
                }
            }
            ++from;
        }
        return from;
    }

    private static final boolean isSeparator(char cc, char[] separators) {
        for (int j = 0; j < separators.length; ++j) {
            if (cc != separators[j] && (separators[j] != ' ' || !Character.isWhitespace(cc))) continue;
            return true;
        }
        return false;
    }

    public static class Result {
        public int next;
        public String token;
        public char separator;

        protected Result(int next, String token, char separator) {
            this.next = next;
            this.token = token;
            this.separator = separator;
        }

        protected Result(int next, char separator) {
            this.next = next;
            this.separator = separator;
        }

        public String toString() {
            return "[next=" + this.next + ", token=" + this.token + " separator=" + this.separator + ']';
        }
    }
}

