/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;

public class Maps {
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final void load(Map map, InputStream sm, String charset, boolean caseInsensitive) throws IOException {
        String line;
        PushbackInputStream pis = new PushbackInputStream(sm, 3);
        if (charset == null || charset.startsWith("UTF")) {
            byte[] ahead = new byte[3];
            int n = pis.read(ahead);
            if (n >= 2 && (ahead[0] == -2 && ahead[1] == -1 || ahead[0] == -1 && ahead[1] == -2)) {
                charset = "UTF-16";
            } else if (n == 3 && ahead[0] == -17 && ahead[1] == -69 && ahead[2] == -65) {
                charset = "UTF-8";
                n = 0;
            } else if (charset == null) {
                charset = "UTF-8";
            }
            if (n > 0) {
                pis.unread(ahead, 0, n);
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pis, charset));
        LinkedList<Integer> prefixes = new LinkedList<Integer>();
        String prefix = null;
        int lno = 1;
        while ((line = in.readLine()) != null) {
            Strings.Result res;
            int len = line.length();
            if (len != 0 && (res = Strings.nextToken(line, 0, new char[]{'=', '{', '}'}, true, false)) != null && !res.token.startsWith("#")) {
                if (res.separator == '\u0000') {
                    if (res.token.length() > 0) {
                        log.warning(">>Igored: a key, " + res.token + ", without value, line " + lno);
                    }
                } else if (res.separator == '{') {
                    if (Strings.skipWhitespaces(line, res.next) < len) {
                        throw new IllegalSyntaxException("Invalid nest: '{' must be the last character, line " + lno);
                    }
                    prefixes.add(new Integer(res.token.length()));
                    prefix = prefix != null ? prefix + res.token : res.token;
                } else if (res.separator == '}') {
                    if (Strings.skipWhitespaces(line, res.next) < len) {
                        throw new IllegalSyntaxException("Invalid nesting: '}' must be the last character, line " + lno);
                    }
                    if (prefixes.isEmpty()) {
                        throw new IllegalSyntaxException("Invalid nesting: '}' does have any preceding '{', line " + lno);
                    }
                    Integer i = (Integer)prefixes.remove(prefixes.size() - 1);
                    prefix = prefixes.isEmpty() ? null : prefix.substring(0, prefix.length() - i);
                } else if (res.token.length() == 0) {
                    log.warning(">>Ignored: wihout key, line " + lno);
                } else {
                    String val;
                    int k;
                    if (!$assertionsDisabled && res.separator != '=') {
                        throw new AssertionError((Object)("Wrong separator: " + res.separator));
                    }
                    String key = caseInsensitive ? res.token.toLowerCase() : res.token;
                    int j = Strings.skipWhitespaces(line, res.next);
                    if (j == (k = Strings.skipWhitespacesBackward(line, len - 1)) && line.charAt(k) == '{') {
                        StringBuffer sb = new StringBuffer();
                        int lnoFrom = lno;
                        while (true) {
                            line = in.readLine();
                            ++lno;
                            if (line == null) {
                                log.warning(">>Ignored: invalid multiple-line format: '={' does not have following '}', " + lnoFrom);
                                break;
                            }
                            len = line.length();
                            if (len > 0 && (j = Strings.skipWhitespacesBackward(line, len - 1)) >= 0 && line.charAt(j) == '}') {
                                if (j > 0) {
                                    j = 1 + Strings.skipWhitespacesBackward(line, j - 1);
                                }
                                if (j == 0) break;
                            }
                            if (sb.length() > 0) {
                                sb.append('\n');
                            }
                            sb.append(line);
                        }
                        val = sb.toString();
                    } else {
                        val = j <= k ? line.substring(j, k + 1) : "";
                    }
                    map.put(prefix != null ? prefix + key : key, val);
                }
            }
            ++lno;
        }
        if (!prefixes.isEmpty()) {
            log.warning(">>Ignored: unclosed nesting '{': " + prefixes.size());
        }
    }

    public static final void load(Map map, InputStream sm, String charset) throws IOException {
        Maps.load(map, sm, charset, false);
    }

    public static final void load(Map map, InputStream sm, boolean caseInsensitive) throws IOException {
        Maps.load(map, sm, null, caseInsensitive);
    }

    public static final void load(Map map, InputStream sm) throws IOException {
        Maps.load(map, sm, null, false);
    }

    public static final Map parse(Map map, String src, char separator, char quote) throws IllegalSyntaxException {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Separator cannot be 0");
        }
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (src == null || src.length() == 0) {
            return map;
        }
        StringBuffer delimsb = new StringBuffer().append(separator);
        if (quote != '\u0000') {
            delimsb.append(quote);
        }
        String delimValue = delimsb.toString();
        String delimKey = delimsb.append('=').toString();
        int j = 0;
        int len = src.length();
        block4: while (true) {
            Token tk = Maps.next(src, delimKey, j, true);
            if (log.finerable()) {
                log.finer("name: " + tk.token + " " + tk.cc);
            }
            j = tk.next;
            String name = tk.token;
            switch (tk.cc) {
                case '=': {
                    if (name.length() == 0) {
                        throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                    }
                    break;
                }
                case '\u0000': {
                    if (!$assertionsDisabled && tk.next < len) {
                        throw new AssertionError();
                    }
                    if (name.length() > 0) {
                        map.put(name, null);
                    }
                    return map;
                }
                default: {
                    if (separator != ' ' && tk.cc != separator || name.length() == 0) {
                        throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                    }
                    map.put(name, null);
                    if (tk.cc != separator) continue block4;
                    ++j;
                    continue block4;
                }
            }
            tk = Maps.next(src, delimValue, ++j, false);
            if (log.finerable()) {
                log.finer("value: " + tk.token + " " + tk.cc);
            }
            j = tk.next;
            String value = tk.token;
            if (quote != '\u0000' && tk.cc == quote) {
                if (value.length() > 0) {
                    throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                }
                StringBuffer valsb = new StringBuffer(32);
                while (true) {
                    if (++j == len) {
                        throw Maps.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, tk.cc, src);
                    }
                    char cc = src.charAt(j);
                    if (cc == tk.cc) break;
                    valsb.append(cc == '\\' ? Maps.escape(src, ++j) : cc);
                }
                map.put(name, valsb.toString());
                ++j;
            } else {
                map.put(name, value);
            }
            if (separator == ' ') continue;
            if ((j = Strings.skipWhitespaces(src, j)) >= len) {
                return map;
            }
            if (src.charAt(j) != separator) {
                throw Maps.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, separator, src);
            }
            ++j;
        }
    }

    private static final IllegalSyntaxException newIllegalSyntaxException(int code, char cc, String src) {
        return new IllegalSyntaxException(code, new Object[]{new Character(cc), src});
    }

    private static final Token next(String src, String delimiters, int j, boolean whitespaceAware) {
        StringBuffer tksb = new StringBuffer(64);
        int len = src.length();
        for (j = Strings.skipWhitespaces(src, j); j < len; ++j) {
            char cc = src.charAt(j);
            if (cc == '\\') {
                tksb.append(Maps.escape(src, ++j));
                continue;
            }
            if (delimiters.indexOf(cc) >= 0) {
                j = Strings.skipWhitespaces(src, j);
                break;
            }
            if (Character.isWhitespace(cc)) {
                int k = Strings.skipWhitespaces(src, j);
                if (whitespaceAware || k >= len || delimiters.indexOf(src.charAt(k)) >= 0) {
                    j = k;
                    break;
                }
                if (j > k - 1) {
                    tksb.append(src.substring(j, k));
                    j = k - 1;
                    continue;
                }
                tksb.append(cc);
                continue;
            }
            if (cc == '\u0000') {
                throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, '\u0000', src);
            }
            tksb.append(cc);
        }
        return new Token(j, j < len ? src.charAt(j) : (char)'\u0000', tksb.toString());
    }

    private static final char escape(String src, int j) {
        if (j >= src.length()) {
            throw new IllegalSyntaxException(MCommon.ILLEGAL_CHAR, "\\");
        }
        char cc = src.charAt(j);
        return (char)(cc == 'n' ? 10 : (cc == 't' ? 9 : (int)cc));
    }

    public static final String toString(Map map, char quote, char separator) {
        return Maps.toStringBuffer(new StringBuffer(64), map, quote, separator).toString();
    }

    public static final StringBuffer toStringBuffer(StringBuffer sb, Map map, char quote, char separator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Separator cannot be 0");
        }
        if (map.isEmpty()) {
            return sb;
        }
        StringBuffer escsb = new StringBuffer(12).append(",\\'\" \n\t").append(separator);
        if (quote != '\u0000' && quote != '\'' && quote != '\"') {
            escsb.append(quote);
        }
        String escValue = escsb.toString();
        String escKey = escsb.append('=').toString();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object key = me.getKey();
            if (key == null) {
                throw new IllegalSyntaxException("Unable to encode null key: " + map);
            }
            String skey = key.toString();
            if (skey == null || skey.length() == 0) {
                throw new IllegalSyntaxException(MCommon.EMPTY_NOT_ALLOWED, "key");
            }
            Maps.encode(sb, skey, escKey);
            Object val = me.getValue();
            if (val != null) {
                sb.append('=');
                if (quote != '\u0000') {
                    sb.append(quote);
                }
                Maps.encode(sb, val.toString(), escValue);
                if (quote != '\u0000') {
                    sb.append(quote);
                }
            }
            sb.append(separator);
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static final void encode(StringBuffer sb, String val, String escapes) {
        int j = 0;
        int len = val.length();
        while (true) {
            int k;
            if ((k = Strings.anyOf(val, escapes, j)) >= len) {
                sb.append(val.substring(j));
                return;
            }
            sb.append(val.substring(j, k)).append('\\');
            char cc = val.charAt(k);
            sb.append((char)(cc == '\n' ? 110 : (cc == '\t' ? 116 : (int)cc)));
            j = k + 1;
        }
    }

    static {
        $assertionsDisabled = !Maps.class.desiredAssertionStatus();
        log = Log.lookup(Maps.class);
    }

    private static class Token {
        private final int next;
        private final char cc;
        private final String token;

        private Token(int next, char cc, String token) {
            this.next = next;
            this.cc = cc;
            this.token = token;
        }
    }
}

