/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.TimeZone;
import org.zkoss.lang.Integers;
import org.zkoss.mesg.MCommon;
import org.zkoss.text.DateFormats;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.Locales;

public class Strings {
    private static Objectizer _objtz = Strings.newDefaultObjectizer();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$TimeZone;

    public static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        int j = s.length();
        while (--j >= 0) {
            if (s.charAt(j) == ' ') continue;
            return false;
        }
        return true;
    }

    public static final StringBuffer encode(StringBuffer sb, int val) {
        do {
            int v;
            if ((v = val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0);
        return sb;
    }

    public static final StringBuffer encode(StringBuffer sb, long val) {
        do {
            int v;
            if ((v = (int)val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0L);
        return sb;
    }

    public static final String encode(int val) {
        return Strings.encode(new StringBuffer(12), val).toString();
    }

    public static final String encode(long val) {
        return Strings.encode(new StringBuffer(20), val).toString();
    }

    public static final int anyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return src.length();
            }
            case 1: {
                int j = src.indexOf(delimiters.charAt(0), from);
                return j >= 0 ? j : src.length();
            }
        }
        int len = src.length();
        while (from < len && delimiters.indexOf(src.charAt(from)) < 0) {
            ++from;
        }
        return from;
    }

    public static final int lastAnyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return -1;
            }
            case 1: {
                return src.lastIndexOf(delimiters.charAt(0), from);
            }
        }
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && delimiters.indexOf(src.charAt(from)) < 0) {
            --from;
        }
        return from;
    }

    public static final int skipWhitespaces(String src, int from) {
        int len = src.length();
        while (from < len && Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final int skipWhitespacesBackward(String src, int from) {
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && Character.isWhitespace(src.charAt(from))) {
            --from;
        }
        return from;
    }

    public static final int nextWhitespace(String src, int from) {
        int len = src.length();
        while (from < len && !Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final String escape(String s, String specials) {
        int k;
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        int len = s.length();
        while ((k = Strings.anyOf(s, specials, j)) < len) {
            if (sb == null) {
                sb = new StringBuffer(len + 4);
            }
            char cc = s.charAt(k);
            switch (cc) {
                case '\n': {
                    cc = 'n';
                    break;
                }
                case '\t': {
                    cc = 't';
                    break;
                }
                case '\r': {
                    cc = 'r';
                    break;
                }
                case '\f': {
                    cc = 'f';
                }
            }
            sb.append(s.substring(j, k)).append('\\').append(cc);
            j = k + 1;
        }
        if (sb == null) {
            return s;
        }
        return sb.append(s.substring(j)).toString();
    }

    public static final StringBuffer appendEscape(StringBuffer sb, String s, String specials) {
        if (s == null) {
            return sb;
        }
        int j = 0;
        int len = s.length();
        int k;
        while ((k = Strings.anyOf(s, specials, j)) < len) {
            char cc = s.charAt(k);
            switch (cc) {
                case '\n': {
                    cc = 'n';
                    break;
                }
                case '\t': {
                    cc = 't';
                    break;
                }
                case '\r': {
                    cc = 'r';
                    break;
                }
                case '\f': {
                    cc = 'f';
                }
            }
            sb.append(s.substring(j, k)).append('\\').append(cc);
            j = k + 1;
        }
        return sb.append(s.substring(j));
    }

    public static final String unescape(String s) {
        int k;
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        while ((k = s.indexOf(92, j)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(s.length());
            }
            char cc = s.charAt(k + 1);
            switch (cc) {
                case 'n': {
                    cc = '\n';
                    break;
                }
                case 't': {
                    cc = '\t';
                    break;
                }
                case 'r': {
                    cc = '\r';
                    break;
                }
                case 'f': {
                    cc = '\f';
                }
            }
            sb.append(s.substring(j, k)).append(cc);
            j = k + 2;
        }
        if (sb == null) {
            return s;
        }
        return sb.append(s.substring(j)).toString();
    }

    public static final Result substring(String src, int from, char until) {
        return Strings.substring(src, from, until, true);
    }

    /*
     * Unable to fully structure code
     */
    public static final Result substring(String src, int from, char until, boolean handleBackslash) {
        len = src.length();
        sb = new StringBuffer(len);
        quoted = false;
        while (from < len) {
            block9: {
                cc = src.charAt(from);
                if (!quoted) break block9;
                quoted = false;
                switch (cc) {
                    case 'f': {
                        cc = '\f';
                        break;
                    }
                    case 'n': {
                        cc = '\n';
                        break;
                    }
                    case 'r': {
                        cc = '\r';
                        break;
                    }
                    case 't': {
                        cc = '\t';
                    }
                }
                ** GOTO lbl-1000
            }
            if (cc == until) break;
            if (handleBackslash && cc == '\\') {
                quoted = true;
            } else lbl-1000:
            // 2 sources

            {
                sb.append(cc);
            }
            ++from;
        }
        return new Result(from, sb.toString(), from < len ? until : '\u0000');
    }

    public static final Result nextToken(String src, int from, char[] separators) throws IllegalSyntaxException {
        return Strings.nextToken(src, from, separators, true, true);
    }

    public static final Result nextToken(String src, int from, char[] separators, boolean handleBackslash, boolean handleQuotation) throws IllegalSyntaxException {
        int j;
        int len = src.length();
        if ((from = Strings.skipWhitespaces(src, from)) >= len) {
            return null;
        }
        char cc = src.charAt(from);
        if (handleQuotation && (cc == '\'' || cc == '\"')) {
            Result res = Strings.substring(src, from + 1, cc, handleBackslash);
            if (res.separator != cc) {
                throw new IllegalSyntaxException(MCommon.QUOTE_UNMATCHED, src);
            }
            res.next = Strings.skipWhitespaces(src, res.next + 1);
            if (res.next < len && Strings.isSeparator(src.charAt(res.next), separators)) {
                ++res.next;
            }
            return res;
        }
        int next = j = Strings.nextSeparator(src, from, separators, handleBackslash, handleQuotation);
        if (j < len) {
            if (handleQuotation) {
                char c = src.charAt(j);
                if (c != '\'' && c != '\"') {
                    ++next;
                }
            } else {
                ++next;
            }
        }
        if (j == from) {
            return new Result(next, "", src.charAt(j));
        }
        int k = 1 + Strings.skipWhitespacesBackward(src, j - 1);
        return new Result(next, k > from ? (handleBackslash ? Strings.unescape(src.substring(from, k)) : src.substring(from, k)) : "", j < len ? src.charAt(j) : (char)'\u0000');
    }

    public static int nextSeparator(String src, int from, char[] separators, boolean handleBackslash, boolean handleQuotation) {
        boolean quoted = false;
        int len = src.length();
        while (from < len) {
            char cc = src.charAt(from);
            if (quoted) {
                quoted = false;
            } else if (handleBackslash && cc == '\\') {
                quoted = true;
            } else {
                if (handleQuotation && (cc == '\'' || cc == '\"')) {
                    return from;
                }
                if (Strings.isSeparator(cc, separators)) {
                    return from;
                }
            }
            ++from;
        }
        return from;
    }

    private static final boolean isSeparator(char cc, char[] separators) {
        for (int j = 0; j < separators.length; ++j) {
            if (cc != separators[j] && (separators[j] != ' ' || !Character.isWhitespace(cc))) continue;
            return true;
        }
        return false;
    }

    public static final String removeSuffix(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public static final String removePrefix(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static final String removeUptoLast(String s, char sep) {
        int j = s.lastIndexOf(sep);
        return j < 0 ? s : s.substring(j + 1);
    }

    public static final String removeSinceLast(String s, char sep) {
        int j = s.lastIndexOf(sep);
        return j < 0 ? s : s.substring(0, j);
    }

    public static final String getSuffix(String s, char sep) {
        int j = s.lastIndexOf(sep);
        return j < 0 || j + 1 >= s.length() ? null : s.substring(j + 1);
    }

    public static final String getPrefix(String s, char sep) {
        int j = s.lastIndexOf(sep);
        return j < 0 ? s : s.substring(0, j);
    }

    public static final String getShortestPrefix(String s, char sep) {
        int j = s.indexOf(sep);
        return j < 0 ? s : s.substring(0, j);
    }

    public static final String capitalize(String s, int j) {
        if (s.length() <= j || Character.isUpperCase(s.charAt(j))) {
            return s;
        }
        char[] buf = s.toCharArray();
        buf[j] = Character.toUpperCase(buf[j]);
        return new String(buf);
    }

    public static final String uncapitalize(String s, int j) {
        if (s.length() <= j || Character.isLowerCase(s.charAt(j))) {
            return s;
        }
        char[] buf = s.toCharArray();
        buf[j] = Character.toLowerCase(buf[j]);
        return new String(buf);
    }

    public static final int getOccurrences(String s, char c) {
        int cnt = 0;
        int len = s != null ? s.length() : 0;
        for (int j = 0; j < len; ++j) {
            if (s.charAt(j) != c) continue;
            ++cnt;
        }
        return cnt;
    }

    public static final String normalize(String s) {
        int len = s.length();
        char[] dst = new char[len];
        boolean white = true;
        boolean modified = false;
        int pos = 0;
        for (int j = 0; j < len; ++j) {
            char cc = s.charAt(j);
            if (" \t\n\r".indexOf(cc) >= 0) {
                if (white) continue;
                dst[pos++] = 32;
                white = true;
                if (cc == ' ') continue;
                modified = true;
                continue;
            }
            dst[pos++] = cc;
            white = false;
        }
        if (white && pos > 0) {
            --pos;
        }
        return !modified && pos == s.length() ? s : new String(dst, 0, pos);
    }

    public static final String convertBackslash(String src) {
        int len = src.length();
        StringBuffer sb = new StringBuffer(len);
        int j = 0;
        while (j < len) {
            int cc;
            if ((cc = src.charAt(j++)) == 92) {
                if ((cc = src.charAt(j++)) == 117) {
                    int value = 0;
                    for (int k = 0; k < 4; ++k) {
                        if ((cc = (int)src.charAt(j++)) >= 48 && cc <= 57) {
                            value = (value << 4) + cc - 48;
                            continue;
                        }
                        if (cc >= 97 && cc <= 102) {
                            value = (value << 4) + 10 + cc - 97;
                            continue;
                        }
                        if (cc >= 65 && cc <= 70) {
                            value = (value << 4) + 10 + cc - 65;
                            continue;
                        }
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    sb.append((char)value);
                    continue;
                }
                if (cc == 116) {
                    cc = 9;
                } else if (cc == 114) {
                    cc = 13;
                } else if (cc == 110) {
                    cc = 10;
                } else if (cc == 102) {
                    cc = 12;
                }
                sb.append((char)cc);
                continue;
            }
            sb.append((char)cc);
        }
        return sb.toString();
    }

    public static final Object toObject(Class type, String str) throws NoSuchMethodException, InstantiationException, ParseException, IllegalAccessException, InvocationTargetException {
        return _objtz.toObject(type, str);
    }

    public static final Objectizer setObjectizer(Objectizer objtz) {
        Objectizer old = _objtz;
        _objtz = objtz != null ? objtz : Strings.newDefaultObjectizer();
        return old;
    }

    private static Objectizer newDefaultObjectizer() {
        return new Objectizer(){

            public Object toObject(Class type, String str) throws NoSuchMethodException, InstantiationException, ParseException, IllegalAccessException, InvocationTargetException {
                if (str == null && !type.isPrimitive()) {
                    return null;
                }
                if ((class$java$lang$String == null ? (class$java$lang$String = Strings.class$("java.lang.String")) : class$java$lang$String) == type) {
                    return str;
                }
                if ((array$C == null ? (array$C = Strings.class$("[C")) : array$C) == type) {
                    return str.toCharArray();
                }
                if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = Strings.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || Boolean.TYPE == type) {
                    return Boolean.valueOf(str);
                }
                if ((class$java$lang$Byte == null ? (class$java$lang$Byte = Strings.class$("java.lang.Byte")) : class$java$lang$Byte) == type || Byte.TYPE == type) {
                    return Byte.valueOf(Strings.trimForDigits(str));
                }
                if ((class$java$lang$Character == null ? (class$java$lang$Character = Strings.class$("java.lang.Character")) : class$java$lang$Character) == type || Character.TYPE == type) {
                    return new Character(str.charAt(0));
                }
                if ((class$java$lang$Short == null ? (class$java$lang$Short = Strings.class$("java.lang.Short")) : class$java$lang$Short) == type || Short.TYPE == type) {
                    return Short.valueOf(Strings.trimForDigits(str));
                }
                if ((class$java$lang$Integer == null ? (class$java$lang$Integer = Strings.class$("java.lang.Integer")) : class$java$lang$Integer) == type || Integer.TYPE == type) {
                    return Integer.valueOf(Strings.trimForDigits(str));
                }
                if ((class$java$lang$Long == null ? (class$java$lang$Long = Strings.class$("java.lang.Long")) : class$java$lang$Long) == type || Long.TYPE == type) {
                    return Long.valueOf(Strings.trimForDigits(str));
                }
                if ((class$java$lang$Float == null ? (class$java$lang$Float = Strings.class$("java.lang.Float")) : class$java$lang$Float) == type || Float.TYPE == type) {
                    return Float.valueOf(str.trim());
                }
                if ((class$java$lang$Double == null ? (class$java$lang$Double = Strings.class$("java.lang.Double")) : class$java$lang$Double) == type || Double.TYPE == type) {
                    return Double.valueOf(str.trim());
                }
                if ((class$java$util$Date == null ? (class$java$util$Date = Strings.class$("java.util.Date")) : class$java$util$Date) == type) {
                    return DateFormats.parse(str);
                }
                if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Strings.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) == type) {
                    return new BigDecimal(Strings.trimForDigits(str));
                }
                if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = Strings.class$("java.math.BigInteger")) : class$java$math$BigInteger) == type) {
                    return new BigInteger(Strings.trimForDigits(str));
                }
                if ((class$java$util$Locale == null ? (class$java$util$Locale = Strings.class$("java.util.Locale")) : class$java$util$Locale) == type) {
                    return Locales.getLocale(str, '\u0000');
                }
                if ((class$java$util$TimeZone == null ? (class$java$util$TimeZone = Strings.class$("java.util.TimeZone")) : class$java$util$TimeZone) == type) {
                    return TimeZone.getTimeZone(str);
                }
                return type.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Strings.class$("java.lang.String")) : class$java$lang$String).newInstance(str);
            }
        };
    }

    private static final String trimForDigits(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int j = 0; j < len; ++j) {
            char cc = str.charAt(j);
            if (!Character.isDigit(cc) && cc != '.' && cc != '-') continue;
            sb.append(cc);
        }
        return sb.toString();
    }

    public static final String prefix(String str, String pre, char delimiter) {
        if (str == null || pre == null || pre.length() == 0) {
            return str;
        }
        return pre + delimiter + str;
    }

    public static final String advance(String id, int step) {
        int val;
        int digits;
        char cc;
        int len;
        int j = len = id.length();
        while (--j >= 0 && (cc = id.charAt(j)) >= '0' && cc <= '9') {
        }
        if ((digits = len - ++j) == 0) {
            val = 0;
            digits = 2;
        } else {
            val = Integer.parseInt(id.substring(j));
        }
        return id.substring(0, j) + Integers.toStringByScale(val + step, digits);
    }

    public static final String nStrings(int n, String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static interface Objectizer {
        public Object toObject(Class var1, String var2) throws NoSuchMethodException, InstantiationException, ParseException, IllegalAccessException, InvocationTargetException;
    }

    public static class Result {
        public int next;
        public String token;
        public char separator;

        protected Result(int next, String token, char separator) {
            this.next = next;
            this.token = token;
            this.separator = separator;
        }

        protected Result(int next, char separator) {
            this.next = next;
            this.separator = separator;
        }

        public String toString() {
            return "[next=" + this.next + ", token=" + this.token + " separator=" + this.separator + ']';
        }
    }
}

