/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xml;

import org.owasp.encoder.Encode;
import org.zkoss.idom.Verifier;

public class XMLs {
    public static final String toXMLName(String name) {
        if (name == null || name.length() == 0) {
            return "_";
        }
        StringBuffer sb = null;
        int len = name.length();
        for (int j = 0; j < len; ++j) {
            char cc = name.charAt(j);
            if (j == 0 && !Verifier.isXMLNameStartCharacter(cc) || cc == ':' || !Verifier.isXMLNameCharacter(cc)) {
                if (sb == null) {
                    sb = new StringBuffer(len + 8);
                    if (j > 0) {
                        sb.append(name.substring(0, j));
                    }
                }
                sb.append('_').append(Integer.toHexString(cc));
                continue;
            }
            if (sb == null) continue;
            sb.append(cc);
        }
        return sb != null ? sb.toString() : name;
    }

    public static final String encodeAttribute(String value) {
        StringBuffer sb = null;
        int len = value.length();
        block4: for (int j = 0; j < len; ++j) {
            String rep;
            char cc = value.charAt(j);
            switch (cc) {
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '&': {
                    rep = "&amp;";
                    break;
                }
                default: {
                    if (sb == null) continue block4;
                    sb.append(cc);
                    continue block4;
                }
            }
            if (sb == null) {
                sb = new StringBuffer(len + 8);
                if (j > 0) {
                    sb.append(value.substring(0, j));
                }
            }
            sb.append(rep);
        }
        return sb != null ? sb.toString() : value;
    }

    public static final String encodeText(String value) {
        StringBuffer sb = null;
        int len = value.length();
        block6: for (int j = 0; j < len; ++j) {
            String rep;
            char cc = value.charAt(j);
            switch (cc) {
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                    break;
                }
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(cc);
                    continue block6;
                }
            }
            if (sb == null) {
                sb = new StringBuffer(len + 8);
                if (j > 0) {
                    sb.append(value.substring(0, j));
                }
            }
            sb.append(rep);
        }
        return sb != null ? sb.toString() : value;
    }

    public static final StringBuffer encodeText(StringBuffer sb, String value) {
        int len = value.length();
        if (sb == null) {
            sb = new StringBuffer(len);
        }
        block6: for (int j = 0; j < len; ++j) {
            char cc = value.charAt(j);
            switch (cc) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(cc);
                }
            }
        }
        return sb;
    }

    public static final StringBuffer encodeText(StringBuffer sb, String value, int begin, int end) {
        if (end > value.length()) {
            end = value.length();
        }
        if (sb == null) {
            sb = new StringBuffer(end - begin + 8);
        }
        block6: for (int j = begin; j < end; ++j) {
            char cc = value.charAt(j);
            switch (cc) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(cc);
                }
            }
        }
        return sb;
    }

    public static final String escapeXML(String s) {
        return Encode.forHtml((String)s);
    }

    public static final String escapeXML(char cc) {
        switch (cc) {
            case '\"': {
                return "&#034;";
            }
            case '\'': {
                return "&#039;";
            }
            case '>': {
                return "&gt;";
            }
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }
}

