/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.fn;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.Messages;
import org.zkoss.text.DateFormats;
import org.zkoss.text.MessageFormats;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.util.resource.Labels;

public class CommonFns {
    private static final Logger log = LoggerFactory.getLogger(CommonFns.class);

    protected CommonFns() {
    }

    public static boolean toBoolean(Object val) {
        return (Boolean)Classes.coerce(Boolean.TYPE, val);
    }

    public static String toString(Object val) {
        return (String)Classes.coerce(String.class, val);
    }

    public static Number toNumber(Object val) {
        return (Number)Classes.coerce(Number.class, val);
    }

    public static int toInt(Object val) {
        return (Integer)Classes.coerce(Integer.TYPE, val);
    }

    public static BigDecimal toDecimal(Object val) {
        return (BigDecimal)Classes.coerce(BigDecimal.class, val);
    }

    public static char toChar(Object val) {
        return ((Character)Classes.coerce(Character.TYPE, val)).charValue();
    }

    public static boolean isInstance(Object c, Object o) {
        if (c instanceof Class) {
            return ((Class)c).isInstance(o);
        }
        if (c instanceof String) {
            try {
                return Classes.forNameByThread((String)c).isInstance(o);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Class not found: " + c);
            }
        }
        throw new IllegalArgumentException("Unknown class: " + c);
    }

    public static final String getLabel(String key) {
        if (key == null) {
            return "";
        }
        if (key.startsWith("mesg:")) {
            int j = key.lastIndexOf(58);
            if (j > 5) {
                String clsnm = key.substring(5, j);
                String fldnm = key.substring(j + 1);
                try {
                    Class<?> cls = Classes.forNameByThread(clsnm);
                    Field fld = cls.getField(fldnm);
                    return Messages.get((Integer)fld.get(null));
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Class not found: {}", (Object)clsnm, (Object)ex);
                }
                catch (NoSuchFieldException ex) {
                    log.warn("Field not found: {}", (Object)fldnm, (Object)ex);
                }
                catch (IllegalAccessException ex) {
                    log.warn("Field not accessible: {}", (Object)fldnm, (Object)ex);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Not a valid format: {}", (Object)key);
            }
        }
        return Labels.getLabel(key);
    }

    public static final String getLabel(String key, Object[] args) {
        String s = CommonFns.getLabel(key);
        return s != null ? MessageFormats.format(s, args, null) : null;
    }

    public static final int length(Object o) {
        if (o instanceof String) {
            return ((String)o).length();
        }
        if (o == null) {
            return 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new IllegalArgumentException("Unknown object for length: " + o.getClass());
    }

    public static final int indexOf(Object o, Object element) {
        if (o instanceof String) {
            return element instanceof String ? ((String)o).indexOf((String)element) : -1;
        }
        if (o instanceof Collection) {
            int j = 0;
            Iterator it = ((Collection)o).iterator();
            while (it.hasNext()) {
                if (Objects.equals(it.next(), element)) {
                    return j;
                }
                ++j;
            }
        } else {
            if (o instanceof Map) {
                return CommonFns.indexOf(((Map)o).keySet(), element);
            }
            if (o instanceof Object[]) {
                Object[] ary = (Object[])o;
                for (int j = 0; j < ary.length; ++j) {
                    if (!Objects.equals(ary[j], element)) continue;
                    return j;
                }
            } else if (o instanceof int[]) {
                if (element instanceof Number) {
                    int v = ((Number)element).intValue();
                    int[] ary = (int[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (ary[j] != v) continue;
                        return j;
                    }
                }
            } else if (o instanceof long[]) {
                if (element instanceof Number) {
                    long v = ((Number)element).longValue();
                    long[] ary = (long[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (ary[j] != v) continue;
                        return j;
                    }
                }
            } else if (o instanceof short[]) {
                if (element instanceof Number) {
                    short v = ((Number)element).shortValue();
                    short[] ary = (short[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (ary[j] != v) continue;
                        return j;
                    }
                }
            } else if (o instanceof byte[]) {
                if (element instanceof Number) {
                    byte v = ((Number)element).byteValue();
                    byte[] ary = (byte[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (ary[j] != v) continue;
                        return j;
                    }
                }
            } else if (o instanceof double[]) {
                if (element instanceof Number) {
                    double v = ((Number)element).doubleValue();
                    double[] ary = (double[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (Double.compare(ary[j], v) != 0) continue;
                        return j;
                    }
                }
            } else if (o instanceof float[]) {
                if (element instanceof Number) {
                    float v = ((Number)element).floatValue();
                    float[] ary = (float[])o;
                    for (int j = 0; j < ary.length; ++j) {
                        if (Float.compare(ary[j], v) != 0) continue;
                        return j;
                    }
                }
            } else if (o instanceof char[]) {
                char v;
                if (element instanceof Character) {
                    v = ((Character)element).charValue();
                } else if (element instanceof String && ((String)element).length() > 0) {
                    v = ((String)element).charAt(0);
                } else {
                    return -1;
                }
                char[] ary = (char[])o;
                for (int j = 0; j < ary.length; ++j) {
                    if (ary[j] != v) continue;
                    return j;
                }
            } else if (o != null) {
                throw new IllegalArgumentException("Unknown object for indexOf: " + o.getClass());
            }
        }
        return -1;
    }

    public static final int lastIndexOf(Object o, Object element) {
        if (o instanceof String) {
            return element instanceof String ? ((String)o).lastIndexOf((String)element) : -1;
        }
        if (o instanceof List) {
            int j = ((List)o).size();
            ListIterator it = ((List)o).listIterator(j);
            while (it.hasPrevious()) {
                if (Objects.equals(it.previous(), element)) {
                    return j - 1;
                }
                --j;
            }
        } else if (o instanceof Object[]) {
            Object[] ary = (Object[])o;
            int j = ary.length;
            while (--j >= 0) {
                if (!Objects.equals(ary[j], element)) continue;
                return j;
            }
        } else if (o instanceof int[]) {
            if (element instanceof Number) {
                int v = ((Number)element).intValue();
                int[] ary = (int[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (ary[j] != v) continue;
                    return j;
                }
            }
        } else if (o instanceof long[]) {
            if (element instanceof Number) {
                long v = ((Number)element).longValue();
                long[] ary = (long[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (ary[j] != v) continue;
                    return j;
                }
            }
        } else if (o instanceof short[]) {
            if (element instanceof Number) {
                short v = ((Number)element).shortValue();
                short[] ary = (short[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (ary[j] != v) continue;
                    return j;
                }
            }
        } else if (o instanceof byte[]) {
            if (element instanceof Number) {
                byte v = ((Number)element).byteValue();
                byte[] ary = (byte[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (ary[j] != v) continue;
                    return j;
                }
            }
        } else if (o instanceof double[]) {
            if (element instanceof Number) {
                double v = ((Number)element).doubleValue();
                double[] ary = (double[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (Double.compare(ary[j], v) != 0) continue;
                    return j;
                }
            }
        } else if (o instanceof float[]) {
            if (element instanceof Number) {
                float v = ((Number)element).floatValue();
                float[] ary = (float[])o;
                int j = ary.length;
                while (--j >= 0) {
                    if (Float.compare(ary[j], v) != 0) continue;
                    return j;
                }
            }
        } else if (o instanceof char[]) {
            char v;
            if (element instanceof Character) {
                v = ((Character)element).charValue();
            } else if (element instanceof String && ((String)element).length() > 0) {
                v = ((String)element).charAt(0);
            } else {
                return -1;
            }
            char[] ary = (char[])o;
            int j = ary.length;
            while (--j >= 0) {
                if (ary[j] != v) continue;
                return j;
            }
        } else if (o != null) {
            throw new IllegalArgumentException("Unknown object for indexOf: " + o.getClass());
        }
        return -1;
    }

    public static final Object new_(Object o) throws Exception {
        if (o instanceof String) {
            return Classes.newInstanceByThread((String)o);
        }
        if (o instanceof Class) {
            return ((Class)o).newInstance();
        }
        throw new IllegalArgumentException("Unknow object for new: " + o);
    }

    public static final Object new_(Object o, Object arg) throws Exception {
        if (o instanceof String) {
            return Classes.newInstance(Classes.forNameByThread((String)o), new Object[]{arg});
        }
        if (o instanceof Class) {
            return Classes.newInstance((Class)o, new Object[]{arg});
        }
        throw new IllegalArgumentException("Unknow object for new: " + o);
    }

    public static final Object new_(Object o, Object arg1, Object arg2) throws Exception {
        if (o instanceof String) {
            return Classes.newInstance(Classes.forNameByThread((String)o), new Object[]{arg1, arg2});
        }
        if (o instanceof Class) {
            return Classes.newInstance((Class)o, new Object[]{arg1, arg2});
        }
        throw new IllegalArgumentException("Unknow object for new: " + o);
    }

    public static final Object new_(Object o, Object arg1, Object arg2, Object arg3) throws Exception {
        if (o instanceof String) {
            return Classes.newInstance(Classes.forNameByThread((String)o), new Object[]{arg1, arg2, arg3});
        }
        if (o instanceof Class) {
            return Classes.newInstance((Class)o, new Object[]{arg1, arg2, arg3});
        }
        throw new IllegalArgumentException("Unknow object for new: " + o);
    }

    public static final String formatDate(Date date, String pattern) {
        return CommonFns.formatDate(date, pattern, null, null, null, null);
    }

    public static final Date parseDate(String source, String pattern) throws Exception {
        return CommonFns.parseDate(source, pattern, null, null, null, null);
    }

    public static final String formatNumber(Object value, String format) {
        return CommonFns.formatNumber(value, format, null);
    }

    public static final Number parseNumber(String source, String pattern) throws Exception {
        return CommonFns.parseNumber(source, pattern, null);
    }

    public static final String formatDate(Date date, String pattern, Locale locale, TimeZone timezone, String dateStyle, String timeStyle) {
        return CommonFns.getDateFormat(pattern, locale, timezone, dateStyle, timeStyle).format(date);
    }

    public static final Date parseDate(String source, String pattern, Locale locale, TimeZone timezone, String dateStyle, String timeStyle) throws Exception {
        return CommonFns.getDateFormat(pattern, locale, timezone, dateStyle, timeStyle).parse(source);
    }

    public static final String formatNumber(Object number, String pattern, Locale locale) {
        if (number == null) {
            return "";
        }
        return CommonFns.getDecimalFormat(pattern, locale).format(number);
    }

    public static final Number parseNumber(String source, String pattern, Locale locale) throws Exception {
        return CommonFns.getDecimalFormat(pattern, locale).parse(source);
    }

    private static final DecimalFormat getDecimalFormat(String pattern, Locale locale) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(locale != null ? locale : Locales.getCurrent());
        if (pattern != null) {
            df.applyPattern(pattern);
        }
        return df;
    }

    private static final DateFormat getDateFormat(String pattern, Locale locale, TimeZone timezone, String dateStyle, String timeStyle) {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        if (timezone == null) {
            timezone = TimeZones.getCurrent();
        }
        pattern = CommonFns.getRealFormat(pattern, locale, dateStyle, timeStyle);
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        df.setTimeZone(timezone);
        return df;
    }

    private static final String getRealFormat(String pattern, Locale locale, String dateStyle, String timeStyle) {
        int ds;
        if (pattern.isEmpty()) {
            pattern = null;
        }
        if ((ds = CommonFns.toStyle(dateStyle)) != -111) {
            int ts = CommonFns.toStyle(timeStyle);
            if (ts != -111) {
                return DateFormats.getDateTimeFormat(ds, ts, locale, pattern);
            }
            return DateFormats.getDateFormat(ds, locale, pattern);
        }
        return pattern != null ? pattern : "M/d/yy";
    }

    private static final int toStyle(String style) {
        if (style != null) {
            return "short".equals(style = style.trim().toLowerCase(Locale.ENGLISH)) ? 3 : ("medium".equals(style) ? 2 : ("long".equals(style) ? 1 : ("full".equals(style) ? 0 : -111)));
        }
        return -111;
    }
}

