/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.text.MessageFormats;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.LabelLocator2;
import org.zkoss.util.resource.impl.LabelLoader;
import org.zkoss.util.resource.impl.LabelLoaderImpl;
import org.zkoss.xel.VariableResolver;

public class Labels {
    private static final Logger log;
    private static LabelLoader _loader;

    private Labels() {
    }

    public static final String getLabel(String key) {
        return _loader.getLabel(key);
    }

    public static final String getLabel(String key, Object[] args) {
        String s = Labels.getLabel(key);
        return s != null ? MessageFormats.format(s, args, null) : null;
    }

    public static final String getLabel(String key, String defValue) {
        String s = _loader.getLabel(key);
        return s != null ? s : defValue;
    }

    public static final String getLabel(String key, String defValue, Object[] args) {
        String s = Labels.getLabel(key, defValue);
        return s != null ? MessageFormats.format(s, args, null) : null;
    }

    public static final Map<String, Object> getSegmentedLabels() {
        return _loader.getSegmentedLabels();
    }

    public static final String getRequiredLabel(String key) throws SystemException {
        String s = Labels.getLabel(key);
        if (s == null) {
            throw new SystemException("label not found: " + key);
        }
        return s;
    }

    public static final String getRequiredLabel(String key, Object[] args) {
        String s = Labels.getLabel(key);
        if (s == null) {
            throw new SystemException("label not found: " + key);
        }
        return MessageFormats.format(s, args, null);
    }

    public static final void reset() {
        _loader.reset();
    }

    public static final VariableResolver setVariableResolver(VariableResolver resolv) {
        return _loader.setVariableResolver(resolv);
    }

    public static final void register(LabelLocator locator) {
        _loader.register(locator);
    }

    public static final void register(LabelLocator2 locator) {
        _loader.register(locator);
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(Labels.class);
            try {
                _loader = (LabelLoader)Classes.newInstanceByThread(Library.getProperty("org.zkoss.util.resource.LabelLoader.class", "org.zkoss.util.resource.impl.LabelLoaderImpl"));
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
                if (_loader != null) break block2;
                _loader = new LabelLoaderImpl();
            }
        }
    }
}

