/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import bsh.TargetError;
import bsh.UtilTargetError;
import jakarta.servlet.ServletException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.mesg.MCommon;
import org.zkoss.mesg.Messages;

public class Exceptions {
    private static final Logger log = LoggerFactory.getLogger(Exceptions.class);

    public static final Throwable findCause(Throwable ex, Class<?> cause) {
        while (ex != null) {
            if (cause.isInstance(ex)) {
                return ex;
            }
            ex = Exceptions.getCause(ex);
        }
        return null;
    }

    public static final Throwable getCause(Throwable ex) {
        Throwable t;
        block8: {
            t = ex.getCause();
            if (t == null) {
                try {
                    if (ex instanceof RemoteException) {
                        return ((RemoteException)ex).detail;
                    }
                    if (ex instanceof SAXException) {
                        return ((SAXException)ex).getException();
                    }
                    if (ex instanceof ServletException) {
                        return ((ServletException)ex).getRootCause();
                    }
                    if (ex instanceof TargetError) {
                        return ((TargetError)ex).getTarget();
                    }
                    if (ex instanceof UtilTargetError) {
                        return ((UtilTargetError)ex).t;
                    }
                }
                catch (Throwable e2) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Ignored: unable to resolve " + ex.getClass());
                }
            }
        }
        return t;
    }

    public static final Throwable getRealCause(Throwable ex) {
        Throwable cause;
        while ((cause = Exceptions.getCause(ex)) != null) {
            ex = cause;
        }
        return ex;
    }

    public static final Throwable wrap(Throwable ex, Class<? extends Throwable> targetExceptCls) {
        if (targetExceptCls.isInstance(ex = Exceptions.myToAnother(ex, targetExceptCls))) {
            return ex;
        }
        try {
            return (Throwable)Classes.newInstance(targetExceptCls, new Class[]{Throwable.class}, new Object[]{ex});
        }
        catch (Exception e2) {
            log.warn("Unable to wrap an exception in " + targetExceptCls, (Throwable)e2);
            throw new SystemException(ex);
        }
    }

    private static final Throwable myToAnother(Throwable ex, Class<? extends Throwable> targetExceptCls) {
        if (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        if (ex instanceof UndeclaredThrowableException) {
            ex = ex.getCause();
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        Throwable t = ex;
        while (t != null) {
            if (targetExceptCls.isInstance(t)) {
                return t;
            }
            t = Exceptions.getCause(t);
        }
        return ex;
    }

    public static final Throwable wrap(Throwable ex, Class<? extends Throwable> targetExceptCls, String msg) {
        if (targetExceptCls.isInstance(ex = Exceptions.myToAnother(ex, targetExceptCls))) {
            return ex;
        }
        try {
            return (Throwable)Classes.newInstance(targetExceptCls, new Class[]{String.class, Throwable.class}, new Object[]{msg, ex});
        }
        catch (Exception e2) {
            log.warn("Unable to wrap an exception in " + targetExceptCls, (Throwable)e2);
            throw new SystemException(ex);
        }
    }

    public static final Throwable wrap(Throwable ex, Class<? extends Throwable> targetExceptCls, int code, Object[] fmtArgs) {
        if (targetExceptCls.isInstance(ex = Exceptions.myToAnother(ex, targetExceptCls))) {
            return ex;
        }
        try {
            return (Throwable)Classes.newInstance(targetExceptCls, new Class[]{Integer.TYPE, Object[].class, Throwable.class}, new Object[]{new Integer(code), fmtArgs, ex});
        }
        catch (Exception e2) {
            log.warn("Unable to wrap an exception in " + targetExceptCls, (Throwable)e2);
            throw new SystemException(ex);
        }
    }

    public static final Throwable wrap(Throwable ex, Class<? extends Throwable> targetExceptCls, int code, Object fmtArg) {
        if (targetExceptCls.isInstance(ex = Exceptions.myToAnother(ex, targetExceptCls))) {
            return ex;
        }
        try {
            return (Throwable)Classes.newInstance(targetExceptCls, new Class[]{Integer.TYPE, Object.class, Throwable.class}, new Object[]{new Integer(code), fmtArg, ex});
        }
        catch (Exception e2) {
            log.warn("Unable to wrap an exception in " + targetExceptCls, (Throwable)e2);
            throw new SystemException(ex);
        }
    }

    public static final Throwable wrap(Throwable ex, Class<? extends Throwable> targetExceptCls, int code) {
        if (targetExceptCls.isInstance(ex = Exceptions.myToAnother(ex, targetExceptCls))) {
            return ex;
        }
        try {
            return (Throwable)Classes.newInstance(targetExceptCls, new Class[]{Integer.TYPE, Throwable.class}, new Object[]{new Integer(code), ex});
        }
        catch (Exception e2) {
            log.warn("Unable to wrap an exception in " + targetExceptCls, (Throwable)e2);
            throw new SystemException(ex);
        }
    }

    public static final Throwable unwrap(Throwable ex) {
        while (true) {
            block9: {
                if (ex instanceof InvocationTargetException) {
                    ex = ex.getCause();
                    continue;
                }
                if (ex instanceof UndeclaredThrowableException) {
                    ex = ex.getCause();
                    continue;
                }
                try {
                    Throwable t;
                    if (ex instanceof TargetError) {
                        Throwable t2 = ((TargetError)ex).getTarget();
                        if (t2 != null) {
                            ex = t2;
                        }
                    } else if (ex instanceof UtilTargetError && (t = ((UtilTargetError)ex).t) != null) {
                        ex = t;
                    }
                }
                catch (Throwable e2) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Ignored: unable to resolve " + ex.getClass());
                }
            }
            return ex;
            assert (ex != null) : "null cause";
        }
    }

    public static final String getExtraMessage(Throwable ex) {
        if ((ex = Exceptions.findCause(ex, SQLException.class)) != null) {
            SQLException e = (SQLException)ex;
            return "[SQL: " + e.getErrorCode() + ", " + e.getSQLState() + "]";
        }
        return null;
    }

    public static final String getMessage(Throwable ex) {
        String s2;
        String s;
        Throwable t = ex;
        while ((s = t.getMessage()) == null || s.length() <= 0) {
            if ((t = Exceptions.getCause(t)) != null) continue;
            s = Messages.get(MCommon.UNKNOWN_EXCEPTION, ex.getClass().getName());
            break;
        }
        return (s2 = Exceptions.getExtraMessage(ex)) != null ? s + s2 : s;
    }

    public static final String getMessage(int code, Object[] fmtArgs) {
        return Messages.get(code, fmtArgs);
    }

    public static final String getMessage(int code, Object fmtArg) {
        return Exceptions.getMessage(code, new Object[]{fmtArg});
    }

    public static final String getMessage(int code) {
        return Exceptions.getMessage(code, null);
    }

    public static final String getBriefStackTrace(Throwable t) {
        return Exceptions.formatStackTrace(null, t, ">>", 6).toString();
    }

    public static final String formatStackTrace(Throwable t, String prefix) {
        return Exceptions.formatStackTrace(null, t, prefix).toString();
    }

    public static final StringBuffer formatStackTrace(StringBuffer sb, Throwable t, String prefix) {
        return Exceptions.formatStackTrace(sb, t, prefix, 0);
    }

    public static final StringBuffer formatStackTrace(StringBuffer sb, Throwable t, String prefix, int maxcnt) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        StringBuffer trace = sw.getBuffer();
        if (prefix == null) {
            prefix = "";
        }
        if (maxcnt > 0 || prefix.length() > 0) {
            int len = trace.length();
            if (sb == null) {
                sb = new StringBuffer(len + 256);
            }
            if (maxcnt <= 0) {
                maxcnt = Integer.MAX_VALUE;
            }
            boolean ignoreCount = false;
            int j = 0;
            while (j < len) {
                if (!ignoreCount && --maxcnt < 0) {
                    sb.append(prefix).append("...");
                    break;
                }
                int k = j;
                while (k < len && trace.charAt(k++) != '\n') {
                }
                String frame = trace.substring(j, k);
                sb.append(prefix).append(frame);
                j = k;
                ignoreCount = Exceptions.inStack(frame, "java.") || Exceptions.inStack(frame, "javax.") || Exceptions.inStack(frame, "sun.") || Exceptions.inStack(frame, "bsh.");
            }
        } else {
            if (sb == null) {
                return trace;
            }
            sb.append(trace);
        }
        return sb;
    }

    private static boolean inStack(String frame, String sub) {
        int j = frame.indexOf(sub);
        if (j < 0) {
            return false;
        }
        if (j == 0) {
            return true;
        }
        char cc = frame.charAt(j - 1);
        return !(cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z');
    }
}

