/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.transform;

import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.zkoss.idom.DocType;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXHandler;

public class Transformer {
    private final javax.xml.transform.Transformer _tfmr;
    private boolean _outDocType = true;

    public Transformer() throws TransformerConfigurationException {
        TransformerFactory tf = this.initFactory();
        this._tfmr = tf.newTransformer();
    }

    public Transformer(Source source) throws TransformerConfigurationException {
        TransformerFactory tf = this.initFactory();
        this._tfmr = source != null ? tf.newTransformer(source) : tf.newTransformer();
    }

    private TransformerFactory initFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            tf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            tf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            tf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return tf;
    }

    public final void enableOutputDocType(boolean enable) {
        this._outDocType = enable;
    }

    private final Document processDocType(Document doc) {
        String pubid;
        if (!this._outDocType) {
            return doc;
        }
        DocType dt = doc.getDocType();
        if (dt == null) {
            return doc;
        }
        String sysid = dt.getSystemId();
        if (sysid != null && sysid.length() > 0) {
            this._tfmr.setOutputProperty("doctype-system", sysid);
        }
        if ((pubid = dt.getPublicId()) != null && pubid.length() > 0) {
            this._tfmr.setOutputProperty("doctype-public", pubid);
        }
        return doc;
    }

    public final javax.xml.transform.Transformer getTransformer() {
        return this._tfmr;
    }

    public final void transform(Source source, Result result) throws TransformerException {
        this._tfmr.transform(source, result);
    }

    public final void transform(Document doc, Result result) throws TransformerException {
        this._tfmr.transform(new DOMSource(this.processDocType(doc)), result);
    }

    public final void transform(Element elm, Result result) throws TransformerException {
        this._tfmr.transform(new DOMSource(elm), result);
    }

    public final Document transform(Source source) throws TransformerException {
        SAXHandler hdl = new SAXHandler();
        this._tfmr.transform(source, new SAXResult(hdl));
        return hdl.getDocument();
    }

    public final Document transform(Document doc) throws TransformerException {
        return this.transform(new DOMSource(this.processDocType(doc)));
    }

    public final Document transform(Element elm) throws TransformerException {
        return this.transform(new DOMSource(elm));
    }

    public final Properties getOutputProperties() {
        return this._tfmr.getOutputProperties();
    }

    public final String getOutputProperty(String name) {
        return this._tfmr.getOutputProperty(name);
    }

    public final void setOutputProperty(String name, String value) {
        this._tfmr.setOutputProperty(name, value);
    }

    public final void setOutputProperties(Properties props) {
        this._tfmr.setOutputProperties(props);
    }

    public final ErrorListener getErrorListener() {
        return this._tfmr.getErrorListener();
    }

    public final void setErrorListener(ErrorListener listener) {
        this._tfmr.setErrorListener(listener);
    }
}

