/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.resource.Loader;

public abstract class AbstractLoader<K, V>
implements Loader<K, V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);

    @Override
    public boolean shallCheck(K src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastModified(K src) {
        if (src instanceof URL) {
            URLConnection conn = null;
            try {
                URL url = (URL)src;
                url = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPort(url.getPort()).setPath(url.getPath()).setCustomQuery(url.getQuery()).build().toURL();
                conn = url.openConnection();
                long v = conn.getLastModified();
                long l = v != -1L ? v : 0L;
                return l;
            }
            catch (Throwable ex) {
                long l = -1L;
                return l;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                    }
                    catch (Throwable e) {
                        log.warn("The connection cannot be closed", e);
                    }
                }
            }
        }
        if (src instanceof File) {
            long v = ((File)src).lastModified();
            return v == -1L ? 0L : (v == 0L ? -1L : v);
        }
        if (src == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Unknown source: " + src + "\nOnly File and URL are supported");
    }
}

