/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;

public class Maps {
    private static final Logger log = LoggerFactory.getLogger(Maps.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void load(Map<? super String, ? super String> map, InputStream sm, String charset, boolean caseInsensitive) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(sm, 3);
        if (charset == null || charset.startsWith("UTF")) {
            byte[] ahead = new byte[3];
            int n = pis.read(ahead);
            if (n >= 2 && (ahead[0] == -2 && ahead[1] == -1 || ahead[0] == -1 && ahead[1] == -2)) {
                charset = "UTF-16";
            } else if (n == 3 && ahead[0] == -17 && ahead[1] == -69 && ahead[2] == -65) {
                charset = "UTF-8";
                n = 0;
            } else if (charset == null) {
                charset = "UTF-8";
            }
            if (n > 0) {
                pis.unread(ahead, 0, n);
            }
        }
        LinkedList<Integer> prefixes = new LinkedList<Integer>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pis, charset));){
            String line;
            String prefix = null;
            int lno = 1;
            while ((line = in.readLine()) != null) {
                Strings.Result res;
                int from;
                int len = line.length();
                if (len != 0 && ((from = Strings.skipWhitespaces(line, 0)) >= len || line.charAt(from) != '#') && (res = Strings.nextToken(line, from, new char[]{'=', '{', '}'}, true, false)) != null) {
                    if (res.separator == '\u0000') {
                        if (res.token.length() > 0) {
                            log.warn(">>Igored: a key, " + res.token + ", without value, line " + lno);
                        }
                    } else if (res.separator == '{') {
                        if (Strings.skipWhitespaces(line, res.next) < len) {
                            throw new IllegalSyntaxException("Invalid nest: '{' must be the last character, line " + lno);
                        }
                        prefixes.add(new Integer(res.token.length()));
                        prefix = prefix != null ? prefix + res.token : res.token;
                    } else if (res.separator == '}') {
                        if (Strings.skipWhitespaces(line, res.next) < len) {
                            throw new IllegalSyntaxException("Invalid nesting: '}' must be the last character, line " + lno);
                        }
                        if (prefixes.isEmpty()) {
                            throw new IllegalSyntaxException("Invalid nesting: '}' does have any preceding '{', line " + lno);
                        }
                        Integer i = (Integer)prefixes.remove(prefixes.size() - 1);
                        prefix = prefixes.isEmpty() ? null : prefix.substring(0, prefix.length() - i);
                    } else if (res.token.length() == 0) {
                        log.warn(">>Ignored: wihout key, line " + lno);
                    } else {
                        String val;
                        int k;
                        String key = caseInsensitive ? res.token.toLowerCase(Locale.ENGLISH) : res.token;
                        int j = Strings.skipWhitespaces(line, res.next);
                        if (j == (k = Strings.skipWhitespacesBackward(line, len - 1)) && line.charAt(k) == '{') {
                            StringBuffer sb = new StringBuffer();
                            int lnoFrom = lno;
                            while (true) {
                                line = in.readLine();
                                ++lno;
                                if (line == null) {
                                    log.warn(">>Ignored: invalid multiple-line format: '={' does not have following '}', " + lnoFrom);
                                    break;
                                }
                                len = line.length();
                                if (len > 0 && (j = Strings.skipWhitespacesBackward(line, len - 1)) >= 0 && line.charAt(j) == '}') {
                                    if (j > 0) {
                                        j = 1 + Strings.skipWhitespacesBackward(line, j - 1);
                                    }
                                    if (j == 0) break;
                                }
                                if (sb.length() > 0) {
                                    sb.append('\n');
                                }
                                sb.append(line);
                            }
                            val = sb.toString();
                        } else {
                            val = j <= k ? line.substring(j, k + 1) : "";
                        }
                        map.put((String)(prefix != null ? prefix + key : key), val);
                    }
                }
                ++lno;
            }
        }
        if (!prefixes.isEmpty()) {
            log.warn(">>Ignored: unclosed nesting '{': " + prefixes.size());
        }
    }

    public static final void load(Map<? super String, ? super String> map, InputStream sm, String charset) throws IOException {
        Maps.load(map, sm, charset, false);
    }

    public static final void load(Map<? super String, ? super String> map, InputStream sm, boolean caseInsensitive) throws IOException {
        Maps.load(map, sm, null, caseInsensitive);
    }

    public static final void load(Map<? super String, ? super String> map, InputStream sm) throws IOException {
        Maps.load(map, sm, null, false);
    }

    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char separator, char quote) throws IllegalSyntaxException {
        return Maps.parse0(map, src, '=', separator, quote, false, false, false);
    }

    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char separator, char quote, boolean asValue) throws IllegalSyntaxException {
        return Maps.parse0(map, src, '=', separator, quote, asValue, false, false);
    }

    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char pairSeparator, char separator, char quote) throws IllegalSyntaxException {
        return Maps.parse0(map, src, pairSeparator, separator, quote, false, false, false);
    }

    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char separator, char quote, boolean asValue, boolean parenthesis) throws IllegalSyntaxException {
        return Maps.parse0(map, src, '=', separator, quote, asValue, parenthesis, false);
    }

    public static final Map<? super String, ? super String> parse(Map<? super String, ? super String> map, String src, char pairSeparator, char separator, char quote, boolean asValue, boolean parenthesis) throws IllegalSyntaxException {
        return Maps.parse0(map, src, pairSeparator, separator, quote, asValue, parenthesis, false);
    }

    public static final Map<? super String, Collection<String>> parseMultiple(Map<? super String, Collection<String>> map, String src, char separator, char quote, boolean asValue, boolean parenthesis) throws IllegalSyntaxException {
        return Maps.parse0(map, src, '=', separator, quote, asValue, parenthesis, true);
    }

    public static final Map<? super String, Collection<String>> parseMultiple(Map<? super String, Collection<String>> map, String src, char pairSeparator, char separator, char quote, boolean asValue, boolean parenthesis) throws IllegalSyntaxException {
        return Maps.parse0(map, src, pairSeparator, separator, quote, asValue, parenthesis, true);
    }

    public static final Map parse(Map map, String src, char separator, char quote, boolean asValue, boolean multiple, boolean parenthesis) throws IllegalSyntaxException {
        return Maps.parse0(map, src, '=', separator, quote, asValue, parenthesis, multiple);
    }

    private static final Map parse0(Map map, String src, char pairSeparator, char separator, char quote, boolean asValue, boolean parenthesis, boolean multiple) throws IllegalSyntaxException {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Separator cannot be 0");
        }
        if (map == null) {
            map = new HashMap();
        }
        if (src == null || src.length() == 0) {
            return map;
        }
        boolean sngldblquote = quote == '\u0001';
        StringBuffer delimsb = new StringBuffer().append(separator);
        if (sngldblquote) {
            delimsb.append("\"'");
            quote = (char)34;
        } else if (quote != '\u0000') {
            delimsb.append(quote);
        }
        String delimValue = delimsb.toString();
        String delimKey = delimsb.append(pairSeparator).toString();
        int j = 0;
        int len = src.length();
        while (true) {
            Token tk = Maps.next(src, delimKey, j, true, parenthesis);
            j = tk.next;
            String name = tk.token;
            if (tk.cc == pairSeparator) {
                if (name.length() == 0) {
                    throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                }
                ++j;
            } else {
                if (tk.cc == '\u0000') {
                    if (name.length() > 0) {
                        if (asValue) {
                            Maps.put(map, null, name, multiple);
                        } else {
                            Maps.put(map, name, null, multiple);
                        }
                    }
                    return map;
                }
                if (quote != '\u0000' && (tk.cc == quote || sngldblquote && tk.cc == '\'')) {
                    name = null;
                } else {
                    if (separator != ' ' && tk.cc != separator || name.length() == 0) {
                        throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                    }
                    if (asValue) {
                        Maps.put(map, null, name, multiple);
                    } else {
                        Maps.put(map, name, null, multiple);
                    }
                    if (tk.cc != separator) continue;
                    ++j;
                    continue;
                }
            }
            tk = Maps.next(src, delimValue, j, false, parenthesis);
            j = tk.next;
            String value = tk.token;
            if (quote != '\u0000' && (tk.cc == quote || sngldblquote && tk.cc == '\'')) {
                if (value.length() > 0) {
                    throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, tk.cc, src);
                }
                StringBuffer valsb = new StringBuffer(32);
                while (true) {
                    if (++j == len) {
                        throw Maps.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, tk.cc, src);
                    }
                    char cc = src.charAt(j);
                    if (cc == tk.cc) break;
                    valsb.append(cc == '\\' ? Maps.escape(src, ++j) : cc);
                }
                Maps.put(map, name, valsb.toString(), multiple);
                ++j;
            } else {
                Maps.put(map, name, value, multiple);
            }
            if (separator == ' ') continue;
            if ((j = Strings.skipWhitespaces(src, j)) >= len) {
                return map;
            }
            if (src.charAt(j) != separator) {
                throw Maps.newIllegalSyntaxException(MCommon.EXPECTING_CHARACTER, separator, src);
            }
            ++j;
        }
    }

    private static void put(Map map, String name, String value, boolean multiple) {
        if (multiple) {
            LinkedList<String> l = (LinkedList<String>)map.get(name);
            if (l == null) {
                l = new LinkedList<String>();
                map.put(name, l);
            }
            l.add(value);
        } else {
            map.put(name, value);
        }
    }

    private static final IllegalSyntaxException newIllegalSyntaxException(int code, char cc, String src) {
        return new IllegalSyntaxException(code, new Object[]{new Character(cc), src});
    }

    private static final Token next(String src, String delimiters, int j, boolean whitespaceAware, boolean parenthesis) {
        StringBuffer tksb = new StringBuffer(64);
        int len = src.length();
        for (j = Strings.skipWhitespaces(src, j); j < len; ++j) {
            char endparen;
            int k;
            char cc = src.charAt(j);
            if (cc == '\\') {
                tksb.append(Maps.escape(src, ++j));
                continue;
            }
            if (delimiters.indexOf(cc) >= 0) {
                j = Strings.skipWhitespaces(src, j);
                break;
            }
            if (Character.isWhitespace(cc)) {
                k = Strings.skipWhitespaces(src, j);
                if (whitespaceAware || k >= len || delimiters.indexOf(src.charAt(k)) >= 0) {
                    j = k;
                    break;
                }
                if (j > k - 1) {
                    tksb.append(src.substring(j, k));
                    j = k - 1;
                    continue;
                }
                tksb.append(cc);
                continue;
            }
            if (parenthesis && (endparen = Maps.getEndingParenthesis(cc)) != '\u0000') {
                k = Maps.skipParenthesis(src, j, cc, endparen);
                if (k >= len) {
                    k = len - 1;
                }
                tksb.append(src.substring(j, k + 1));
                j = k;
                continue;
            }
            if (cc == '\u0000') {
                throw Maps.newIllegalSyntaxException(MCommon.UNEXPECTED_CHARACTER, '\u0000', src);
            }
            tksb.append(cc);
        }
        return new Token(j, j < len ? src.charAt(j) : (char)'\u0000', tksb.toString());
    }

    private static final char getEndingParenthesis(char cc) {
        return (char)(cc == '{' ? 125 : (cc == '(' ? 41 : (cc == '[' ? 93 : 0)));
    }

    private static int skipParenthesis(String src, int j, char beg, char end) {
        int len = src.length();
        int depth = 0;
        while (++j < len) {
            char cc = src.charAt(j);
            if (cc == '\\') {
                ++j;
                continue;
            }
            if (cc == beg) {
                ++depth;
                continue;
            }
            if (cc != end || --depth >= 0) continue;
            break;
        }
        return j;
    }

    private static final char escape(String src, int j) {
        if (j >= src.length()) {
            throw new IllegalSyntaxException(MCommon.ILLEGAL_CHAR, "\\");
        }
        char cc = src.charAt(j);
        return (char)(cc == 'n' ? 10 : (cc == 't' ? 9 : (int)cc));
    }

    public static final String toString(Map<? super String, ? super String> map, char quote, char separator) {
        return Maps.toString(map, quote, separator, '=');
    }

    public static final String toString(Map<? super String, ? super String> map, char quote, char separator, char pairSeparator) {
        return Maps.toStringBuffer(new StringBuffer(64), map, quote, separator, pairSeparator).toString();
    }

    public static final StringBuffer toStringBuffer(StringBuffer sb, Map<? super String, ? super String> map, char quote, char separator) {
        return Maps.toStringBuffer(sb, map, quote, separator, '=');
    }

    public static final StringBuffer toStringBuffer(StringBuffer sb, Map<? super String, ? super String> map, char quote, char separator, char pairSeparator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Separator cannot be 0");
        }
        if (map.isEmpty()) {
            return sb;
        }
        StringBuffer escsb = new StringBuffer(12).append(",\\'\" \n\t").append(separator);
        if (quote != '\u0000' && quote != '\'' && quote != '\"') {
            escsb.append(quote);
        }
        String escValue = escsb.toString();
        String escKey = escsb.append(pairSeparator).toString();
        for (Map.Entry<? super String, ? super String> me : map.entrySet()) {
            String key = me.getKey();
            if (key == null) {
                throw new IllegalSyntaxException("Unable to encode null key: " + map);
            }
            String skey = key.toString();
            if (skey == null || skey.length() == 0) {
                throw new IllegalSyntaxException(MCommon.EMPTY_NOT_ALLOWED, "key");
            }
            Maps.encode(sb, skey, escKey);
            String val = me.getValue();
            if (val != null) {
                sb.append(pairSeparator);
                if (quote != '\u0000') {
                    sb.append(quote);
                }
                Maps.encode(sb, val.toString(), escValue);
                if (quote != '\u0000') {
                    sb.append(quote);
                }
            }
            sb.append(separator);
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static final void encode(StringBuffer sb, String val, String escapes) {
        int j = 0;
        int len = val.length();
        while (true) {
            int k;
            if ((k = Strings.anyOf(val, escapes, j)) >= len) {
                sb.append(val.substring(j));
                return;
            }
            sb.append(val.substring(j, k)).append('\\');
            char cc = val.charAt(k);
            sb.append((char)(cc == '\n' ? 110 : (cc == '\t' ? 116 : (int)cc)));
            j = k + 1;
        }
    }

    public static <K, V> Set<SerializableEntry<K, V>> transferToSerializableEntrySet(Set<Map.Entry<K, V>> entry) {
        LinkedHashSet<SerializableEntry<K, V>> newSet = new LinkedHashSet<SerializableEntry<K, V>>(entry.size());
        for (Map.Entry<K, V> me : entry) {
            newSet.add(new SerializableEntry<K, V>(me));
        }
        return newSet;
    }

    public static Map of(Object ... args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    public static class SerializableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 20150121161520L;
        private final K key;
        private V val;

        public SerializableEntry(K key, V val) {
            this.key = key;
            this.val = val;
        }

        public SerializableEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.val = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            V old = this.val;
            this.val = value;
            return old;
        }

        public boolean equals(Map.Entry<K, V> obj) {
            return SerializableEntry.eq(this.key, obj.getKey()) && SerializableEntry.eq(this.val, obj.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.val == null ? 0 : this.val.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private static class Token {
        private final int next;
        private final char cc;
        private final String token;

        private Token(int next, char cc, String token) {
            this.next = next;
            this.cc = cc;
            this.token = token;
        }
    }
}

